//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Oct  2 17:09:36 2024
//	==> using automatic loading with extension .mbs 
//
//	==> Project name: pendulum_spring_c
//
//	==> Number of joints: 4
//
//	==> Function: F6 - Sensors Kinematics
//
//	==> Git hash: 0cc862d03ff17d3428bf53a85358bd520952fe65
//
//	==> Input XML
//

#include <math.h> 

#include "mbs_data.h"
#include "mbs_sensor.h"

void mbs_sensor(MbsSensor *sens,
MbsData *s, int isens)
{
#include "mbs_sensor_pendulum_spring_c.h"

double *q, *qd, *qdd;
double **dpt;

q = s->q;
qd = s->qd;
qdd = s->qdd;

dpt = s->dpt;
 
// Trigonometric functions

S3 = sin(q[3]);
C3 = cos(q[3]);
S4 = sin(q[4]);
C4 = cos(q[4]);
S1 = sin(q[1]);
C1 = cos(q[1]);
 
// Augmented Joint Position Vectors

Dz23 = q[2]+dpt[3][3];
 
// Augmented Joint Position Vectors

 
// Sensor Kinematics


switch(isens)
{
case 1:

ROcp1_14 = C3*C4-S3*S4;
ROcp1_34 = -C3*S4-S3*C4;
ROcp1_74 = C3*S4+S3*C4;
ROcp1_94 = C3*C4-S3*S4;
RLcp1_12 = dpt[3][6]*S3;
RLcp1_32 = dpt[3][6]*C3;
POcp1_12 = RLcp1_12+dpt[1][2];
OMcp1_22 = qd[3]+qd[4];
ORcp1_12 = RLcp1_32*qd[3];
ORcp1_32 = -RLcp1_12*qd[3];
OPcp1_22 = qdd[3]+qdd[4];
ACcp1_12 = ORcp1_32*qd[3]+RLcp1_32*qdd[3];
ACcp1_32 = -ORcp1_12*qd[3]-RLcp1_12*qdd[3];
RLcp1_13 = ROcp1_74*dpt[3][8];
RLcp1_33 = ROcp1_94*dpt[3][8];
POcp1_13 = POcp1_12+RLcp1_13;
POcp1_33 = RLcp1_32+RLcp1_33;
JTcp1_13_1 = RLcp1_32+RLcp1_33;
JTcp1_33_1 = -RLcp1_12-RLcp1_13;
ORcp1_13 = OMcp1_22*RLcp1_33;
ORcp1_33 = -OMcp1_22*RLcp1_13;
VIcp1_13 = ORcp1_12+ORcp1_13;
VIcp1_33 = ORcp1_32+ORcp1_33;
ACcp1_13 = ACcp1_12+OMcp1_22*ORcp1_33+OPcp1_22*RLcp1_33;
ACcp1_33 = ACcp1_32-OMcp1_22*ORcp1_13-OPcp1_22*RLcp1_13;
sens->P[1] = POcp1_13;
sens->P[2] = 0;
sens->P[3] = POcp1_33;
sens->R[1][1] = ROcp1_14;
sens->R[1][3] = ROcp1_34;
sens->R[2][2] = (1.0);
sens->R[3][1] = ROcp1_74;
sens->R[3][3] = ROcp1_94;
sens->V[1] = VIcp1_13;
sens->V[2] = 0;
sens->V[3] = VIcp1_33;
sens->OM[1] = 0;
sens->OM[2] = OMcp1_22;
sens->OM[3] = 0;
sens->J[1][3] = JTcp1_13_1;
sens->J[1][4] = RLcp1_33;
sens->J[3][3] = JTcp1_33_1;
sens->J[3][4] = -RLcp1_13;
sens->J[5][3] = (1.0);
sens->J[5][4] = (1.0);
sens->A[1] = ACcp1_13;
sens->A[2] = 0;
sens->A[3] = ACcp1_33;
sens->OMP[1] = 0;
sens->OMP[2] = OPcp1_22;
sens->OMP[3] = 0;

break;

case 2:

RLcp2_12 = dpt[3][5]*S1;
RLcp2_32 = dpt[3][5]*C1;
ORcp2_12 = RLcp2_32*qd[1];
ORcp2_32 = -RLcp2_12*qd[1];
ACcp2_12 = ORcp2_32*qd[1]+RLcp2_32*qdd[1];
ACcp2_32 = -ORcp2_12*qd[1]-RLcp2_12*qdd[1];
sens->P[1] = RLcp2_12;
sens->P[2] = 0;
sens->P[3] = RLcp2_32;
sens->R[1][1] = C1;
sens->R[1][3] = -S1;
sens->R[2][2] = (1.0);
sens->R[3][1] = S1;
sens->R[3][3] = C1;
sens->V[1] = ORcp2_12;
sens->V[2] = 0;
sens->V[3] = ORcp2_32;
sens->OM[1] = 0;
sens->OM[2] = qd[1];
sens->OM[3] = 0;
sens->A[1] = ACcp2_12;
sens->A[2] = 0;
sens->A[3] = ACcp2_32;
sens->OMP[1] = 0;
sens->OMP[2] = qdd[1];
sens->OMP[3] = 0;

break;

default:

break;

}


// Number of continuation lines = 0

}
